<?php
	global $VISUAL_COMPOSER_EXTENSIONS;
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Star_Rating'))) {
		class WPBakeryShortCode_TS_VCSC_Star_Rating extends WPBakeryShortCode {};
	};
    $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
		"name"                      => __( "TS Rating Scale", "ts_visual_composer_extend" ),
		"base"                      => "TS_VCSC_Star_Rating",
		"icon" 	                    => "ts-composer-element-icon-rating-scale",
		"category"                  => __( "Composium", "ts_visual_composer_extend" ),
		"description"               => __("Place a rating scale element", "ts_visual_composer_extend"),
		"admin_enqueue_js"        	=> "",
		"admin_enqueue_css"       	=> "",
		"params"                    => array(
			// Rating Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_1",
				"seperator"         => "Rating Settings",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Symbol", "ts_visual_composer_extend" ),
				"param_name"        => "rating_symbol",
				"value"             => array(
					__( "Other Icon", "ts_visual_composer_extend" )                 => "other",
					__( "Smileys", "ts_visual_composer_extend" )                    => "smile",
				),
				"admin_label"		=> true,
				"description"       => __( "Select how you want to display the rating.", "ts_visual_composer_extend" ),
			),
			array(
				"type" 				=> "icons_panel",
				"heading" 			=> __( 'Rating Icon', 'ts_visual_composer_extend' ),
				"param_name" 		=> 'rating_icon',
				"value"				=> "",
				"default"			=> "ts-ecommerce-starfull1",
				"settings" 			=> array(
					"emptyIcon" 					=> false,
					"emptyIconValue"				=> 'transparent',
					"hasSearch"						=> false,
					"override"						=> true,
					"type" 							=> 'rating',
				),
				"admin_label"       => true,
				"dependency"        => array( 'element' => "rating_symbol", 'value' => 'other' ),
				"description"       => __( "Select which icon should be used to reflect the rating.", "ts_visual_composer_extend" ),
			),
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Use Shortcode for Rating Value", "ts_visual_composer_extend" ),
				"param_name"        => "rating_shortcode",
				"value"             => "false",
				"description"       => __( "Switch the toggle if you want to use a shortcode to generate the rating value.", "ts_visual_composer_extend" )
			),			
			array(
				"type"              => "nouislider",
				"heading"           => __( "Rating Maximum", "ts_visual_composer_extend" ),
				"param_name"        => "rating_maximum",
				"value"             => "5",
				"min"               => "3",
				"max"               => "10",
				"step"              => "1",
				"decimals"			=> "0",
				"unit"              => '',
				"admin_label"		=> true,
				"callback"			=> 'rating_value',
				"description"       => __( "Define the maximum (best possible) rating in stars.", "ts_visual_composer_extend" )
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Rating Value", "ts_visual_composer_extend" ),
				"param_name"        => "rating_value",
				"value"             => "0",
				"min"               => "0",
				"max"               => "5",
				"step"              => "0.25",
				"decimals"			=> "2",
				"unit"              => '',
				"admin_label"		=> true,
				"callback"			=> 'rating_maximum',
				"dependency"        => array( 'element' => "rating_shortcode", 'value' => 'false' ),
				"description"       => __( "Define the rating in stars (up to the maximum defined above); quarter increments possible.", "ts_visual_composer_extend" )
			),	
			array(
				"type"              => "textarea_raw_html",
				"heading"           => __( "Rating (out of 5.00)", "ts_visual_composer_extend" ),
				"param_name"        => "rating_dynamic",
				"value"             => base64_encode(""),
				"description"       => __( "Enter the shortcode that will dynamically generate the rating value.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "rating_shortcode", 'value' => 'true' ),
			),				
			array(
				"type"				=> "switch_button",
				"heading"           => __( "RTL Alignment", "ts_visual_composer_extend" ),
				"param_name"        => "rating_rtl",
				"value"             => "false",
				"description"       => __( "Switch the toggle if you want to show the rating in 'RTL' (Right-To-Left) alignment.", "ts_visual_composer_extend" )
			),				
			array(
				"type"              => "textfield",
				"heading"           => __( "Title", "ts_visual_composer_extend" ),
				"param_name"        => "rating_title",
				"value"             => "",
				"description"       => __( "Enter an optional title for the rating.", "ts_visual_composer_extend" ),
				"admin_label"		=> true,
			),
			// Style Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_2",
				"seperator"         => "Style Settings",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Max. Icon Size", "ts_visual_composer_extend" ),
				"param_name"        => "rating_size",
				"value"             => "25",
				"min"               => "12",
				"max"               => "512",
				"step"              => "1",
				"decimals"			=> "0",
				"unit"              => 'px',
				"admin_label"		=> true,
				"description"       => __( "Select the maximum individual rating icon size; site will scale to fit into column if necessary.", "ts_visual_composer_extend" ),
			),
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Auto-Size Adjust", "ts_visual_composer_extend" ),
				"param_name"        => "rating_auto",
				"value"             => "true",
				"admin_label"		=> true,
				"description"       => __( "Switch the toggle if you want the rating to automatically adjust the icon size in order to fit into columns.", "ts_visual_composer_extend" )
			),				
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Rated Icon Fill Color", "ts_visual_composer_extend" ),
				"param_name"        => "color_rated",
				"value"             => "#FFD800",
				"description"       => __( "Define the fill color for the rated icons.", "ts_visual_composer_extend" ),
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Empty Icon Fill Color", "ts_visual_composer_extend" ),
				"param_name"        => "color_empty",
				"value"             => "#e3e3e3",
				"description"       => __( "Define the fill color for the empty icons.", "ts_visual_composer_extend" ),
			),
			// Rating Caption
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_3",
				"seperator"         => "Caption Settings",
				"group" 			=> "Caption Settings",
			),
			array(
				"type"				=> "switch_button",
				"heading"           => __( "Show Rating Caption", "ts_visual_composer_extend" ),
				"param_name"        => "caption_show",
				"value"             => "true",
				"description"       => __( "Switch the toggle if you also want to show a caption with the rating as number.", "ts_visual_composer_extend" ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Position", "ts_visual_composer_extend" ),
				"param_name"        => "caption_position",
				"value"             => array(
					__( "Left", "ts_visual_composer_extend" )					=> "left",
					__( "Right", "ts_visual_composer_extend" )					=> "right",
				),
				"description"       => __( "Select where the numeric rating caption block should be placed.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "dropdown",
				"heading"           => __( "Decimals Seperator", "ts_visual_composer_extend" ),
				"param_name"        => "caption_digits",
				"width"             => 150,
				"value"             => array(
					__( 'Dot', "ts_visual_composer_extend" )          => ".",
					__( 'Comma', "ts_visual_composer_extend" )        => ",",                        
					__( 'Space', "ts_visual_composer_extend" )        => " ",
				),
				"description"       => __( "Select a character to separate decimals in the rating value.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Caption Background 0-1", "ts_visual_composer_extend" ),
				"param_name"        => "caption_danger",
				"value"             => "#d9534f",
				"description"       => __( "Define the caption background for rating values between 0 - 1.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Caption Background 1-2", "ts_visual_composer_extend" ),
				"param_name"        => "caption_warning",
				"value"             => "#f0ad4e",
				"description"       => __( "Define the caption background for rating values between 1 - 2.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Caption Background 2-3", "ts_visual_composer_extend" ),
				"param_name"        => "caption_info",
				"value"             => "#5bc0de",
				"description"       => __( "Define the caption background for rating values between 2 - 3.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Caption Background 3-4", "ts_visual_composer_extend" ),
				"param_name"        => "caption_primary",
				"value"             => "#428bca",
				"description"       => __( "Define the caption background for rating values between 3 - 4.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			array(
				"type"              => "colorpicker",
				"heading"           => __( "Caption Background 4-5", "ts_visual_composer_extend" ),
				"param_name"        => "caption_success",
				"value"             => "#5cb85c",
				"description"       => __( "Define the caption background for rating values between 4 - 5.", "ts_visual_composer_extend" ),
				"dependency"        => array( 'element' => "caption_show", 'value' => 'true' ),
				"group" 			=> "Caption Settings",
			),
			// Rating Tooltip
			array(
				"type"				=> "seperator",
				"param_name"		=> "seperator_4",
				"seperator"         => "Tooltip Settings",
				"group" 			=> "Tooltip Settings",
			),
			array(
				"type"				=> "switch_button",
				"heading"			=> __( "Use Advanced Tooltip", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_css",
				"value"				=> "false",
				"description"       => __( "Switch the toggle if you want to apply an advanced tooltip to the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Tooltip Settings",
			),
			array(
				"type"				=> "textarea",
				"heading"			=> __( "Tooltip Content", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_content",
				"value"				=> "",
				"description"		=> __( "Enter the tooltip content here (do not use quotation marks).", "ts_visual_composer_extend" ),
				"group" 			=> "Tooltip Settings",
			),
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Tooltip Position", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_position",
				"value"				=> $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Vertical,
				"description"		=> __( "Select the tooltip position in relation to the element.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "tooltip_css", 'value' => 'true' ),
				"group" 			=> "Tooltip Settings",
			),
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Tooltip Style", "ts_visual_composer_extend" ),
				"param_name"		=> "tooltip_style",
				"value"             => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_ToolTipster_Layouts,
				"description"		=> __( "Select the tooltip style.", "ts_visual_composer_extend" ),
				"dependency"		=> array( 'element' => "tooltip_css", 'value' => 'true' ),
				"group" 			=> "Tooltip Settings",
			),
			// Other Rating Settings
			array(
				"type"              => "seperator",
				"param_name"        => "seperator_5",
				"seperator"         => "Other Settings",
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Margin: Top", "ts_visual_composer_extend" ),
				"param_name"        => "margin_top",
				"value"             => "20",
				"min"               => "-50",
				"max"               => "500",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "nouislider",
				"heading"           => __( "Margin: Bottom", "ts_visual_composer_extend" ),
				"param_name"        => "margin_bottom",
				"value"             => "20",
				"min"               => "-50",
				"max"               => "500",
				"step"              => "1",
				"unit"              => 'px',
				"description"       => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"              => "textfield",
				"heading"           => __( "Define ID Name", "ts_visual_composer_extend" ),
				"param_name"        => "el_id",
				"value"             => "",
				"description"       => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
				"group" 			=> "Other Settings",
			),
			array(
				"type"				=> "tag_editor",
				"heading"			=> __( "Extra Class Names", "ts_visual_composer_extend" ),
				"param_name"		=> "el_class",
				"value"				=> "",
				"description"		=> __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
				"group"				=> "Other Settings",
			),
		)
	);	
	if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
		return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
	} else {			
		vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
	};
?>